/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Calendar;
import java.util.TimeZone;
import org.mariadb.jdbc.MariaDbConnection;
import org.mariadb.jdbc.MariaDbStatement;
import org.mariadb.jdbc.internal.ColumnType;
import org.mariadb.jdbc.internal.com.send.parameters.BigDecimalParameter;
import org.mariadb.jdbc.internal.com.send.parameters.ByteArrayParameter;
import org.mariadb.jdbc.internal.com.send.parameters.ByteParameter;
import org.mariadb.jdbc.internal.com.send.parameters.DateParameter;
import org.mariadb.jdbc.internal.com.send.parameters.DoubleParameter;
import org.mariadb.jdbc.internal.com.send.parameters.FloatParameter;
import org.mariadb.jdbc.internal.com.send.parameters.IntParameter;
import org.mariadb.jdbc.internal.com.send.parameters.LongParameter;
import org.mariadb.jdbc.internal.com.send.parameters.NullParameter;
import org.mariadb.jdbc.internal.com.send.parameters.OffsetTimeParameter;
import org.mariadb.jdbc.internal.com.send.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.com.send.parameters.ReaderParameter;
import org.mariadb.jdbc.internal.com.send.parameters.SerializableParameter;
import org.mariadb.jdbc.internal.com.send.parameters.ShortParameter;
import org.mariadb.jdbc.internal.com.send.parameters.StreamParameter;
import org.mariadb.jdbc.internal.com.send.parameters.StringParameter;
import org.mariadb.jdbc.internal.com.send.parameters.TimeParameter;
import org.mariadb.jdbc.internal.com.send.parameters.TimestampParameter;
import org.mariadb.jdbc.internal.com.send.parameters.ZonedDateTimeParameter;
import org.mariadb.jdbc.internal.util.exceptions.ExceptionMapper;

public abstract class BasePrepareStatement
extends MariaDbStatement
implements PreparedStatement {
    private static final DateTimeFormatter SPEC_ISO_ZONED_DATE_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).optionalStart().appendLiteral('T').optionalEnd().optionalStart().appendLiteral(' ').optionalEnd().append(DateTimeFormatter.ISO_LOCAL_TIME).appendOffsetId().optionalStart().appendLiteral('[').parseCaseSensitive().appendZoneRegionId().appendLiteral(']').toFormatter();
    protected boolean useFractionalSeconds;
    protected boolean hasLongData = false;

    public BasePrepareStatement(MariaDbConnection connection, int resultSetScrollType) {
        super(connection, resultSetScrollType);
        this.useFractionalSeconds = this.options.useFractionalSeconds;
    }

    @Override
    public BasePrepareStatement clone(MariaDbConnection connection) throws CloneNotSupportedException {
        BasePrepareStatement base = (BasePrepareStatement)super.clone(connection);
        base.useFractionalSeconds = this.options.useFractionalSeconds;
        return base;
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        if (this.executeInternal(this.getFetchSize())) {
            return 0L;
        }
        return this.getLargeUpdateCount();
    }

    protected abstract boolean executeInternal(int var1) throws SQLException;

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        if (reader == null) {
            this.setNull(parameterIndex, ColumnType.BLOB);
            return;
        }
        this.setParameter(parameterIndex, new ReaderParameter(reader, length, this.connection.noBackslashEscapes));
        this.hasLongData = true;
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        if (reader == null) {
            this.setNull(parameterIndex, ColumnType.BLOB);
            return;
        }
        this.setParameter(parameterIndex, new ReaderParameter(reader, length, this.connection.noBackslashEscapes));
        this.hasLongData = true;
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        if (reader == null) {
            this.setNull(parameterIndex, ColumnType.BLOB);
            return;
        }
        this.setParameter(parameterIndex, new ReaderParameter(reader, this.connection.noBackslashEscapes));
        this.hasLongData = true;
    }

    @Override
    public void setRef(int parameterIndex, Ref ref) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("REF not supported");
    }

    @Override
    public void setBlob(int parameterIndex, Blob blob) throws SQLException {
        if (blob == null) {
            this.setNull(parameterIndex, 2004);
            return;
        }
        this.setParameter(parameterIndex, new StreamParameter(blob.getBinaryStream(), blob.length(), this.connection.noBackslashEscapes));
        this.hasLongData = true;
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        if (inputStream == null) {
            this.setNull(parameterIndex, ColumnType.BLOB);
            return;
        }
        this.setParameter(parameterIndex, new StreamParameter(inputStream, length, this.connection.noBackslashEscapes));
        this.hasLongData = true;
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        if (inputStream == null) {
            this.setNull(parameterIndex, ColumnType.BLOB);
            return;
        }
        this.setParameter(parameterIndex, new StreamParameter(inputStream, this.connection.noBackslashEscapes));
        this.hasLongData = true;
    }

    @Override
    public void setClob(int parameterIndex, Clob clob) throws SQLException {
        if (clob == null) {
            this.setNull(parameterIndex, ColumnType.BLOB);
            return;
        }
        this.setParameter(parameterIndex, new ReaderParameter(clob.getCharacterStream(), clob.length(), this.connection.noBackslashEscapes));
        this.hasLongData = true;
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setArray(int parameterIndex, Array array) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Arrays not supported");
    }

    @Override
    public void setDate(int parameterIndex, Date date, Calendar cal) throws SQLException {
        if (date == null) {
            this.setNull(parameterIndex, 91);
            return;
        }
        this.setParameter(parameterIndex, new DateParameter(date, cal != null ? cal.getTimeZone() : TimeZone.getDefault(), this.protocol.getOptions()));
    }

    @Override
    public void setDate(int parameterIndex, Date date) throws SQLException {
        if (date == null) {
            this.setNull(parameterIndex, 91);
            return;
        }
        this.setParameter(parameterIndex, new DateParameter(date, TimeZone.getDefault(), this.protocol.getOptions()));
    }

    @Override
    public void setTime(int parameterIndex, Time time, Calendar cal) throws SQLException {
        if (time == null) {
            this.setNull(parameterIndex, ColumnType.TIME);
            return;
        }
        this.setParameter(parameterIndex, new TimeParameter(time, cal != null ? cal.getTimeZone() : TimeZone.getDefault(), this.useFractionalSeconds));
    }

    @Override
    public void setTime(int parameterIndex, Time time) throws SQLException {
        if (time == null) {
            this.setNull(parameterIndex, ColumnType.TIME);
            return;
        }
        this.setParameter(parameterIndex, new TimeParameter(time, TimeZone.getDefault(), this.useFractionalSeconds));
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp timestamp, Calendar cal) throws SQLException {
        if (timestamp == null) {
            this.setNull(parameterIndex, ColumnType.DATETIME);
            return;
        }
        TimeZone tz = cal != null ? cal.getTimeZone() : this.protocol.getTimeZone();
        this.setParameter(parameterIndex, new TimestampParameter(timestamp, tz, this.useFractionalSeconds));
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp timestamp) throws SQLException {
        if (timestamp == null) {
            this.setNull(parameterIndex, ColumnType.DATETIME);
            return;
        }
        this.setParameter(parameterIndex, new TimestampParameter(timestamp, this.protocol.getTimeZone(), this.useFractionalSeconds));
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.setParameter(parameterIndex, new NullParameter());
    }

    public void setNull(int parameterIndex, ColumnType mysqlType) throws SQLException {
        this.setParameter(parameterIndex, new NullParameter(mysqlType));
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.setParameter(parameterIndex, new NullParameter());
    }

    protected abstract void setParameter(int var1, ParameterHolder var2) throws SQLException;

    @Override
    public void setURL(int parameterIndex, URL url) throws SQLException {
        if (url == null) {
            this.setNull(parameterIndex, ColumnType.STRING);
            return;
        }
        this.setParameter(parameterIndex, new StringParameter(url.toString(), this.connection.noBackslashEscapes));
    }

    @Override
    public abstract ParameterMetaData getParameterMetaData() throws SQLException;

    @Override
    public void setRowId(int parameterIndex, RowId rowid) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("RowIDs not supported");
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.setString(parameterIndex, value);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.setCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.setCharacterStream(parameterIndex, value);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.setClob(parameterIndex, value);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setClob(parameterIndex, reader, length);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.setClob(parameterIndex, reader);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("SQlXML not supported");
    }

    @Override
    public void setObject(int parameterIndex, Object obj, int targetSqlType, int scaleOrLength) throws SQLException {
        this.setInternalObject(parameterIndex, obj, targetSqlType, scaleOrLength);
    }

    @Override
    public void setObject(int parameterIndex, Object obj, int targetSqlType) throws SQLException {
        this.setInternalObject(parameterIndex, obj, targetSqlType, Long.MAX_VALUE);
    }

    @Override
    public void setObject(int parameterIndex, Object obj) throws SQLException {
        if (obj == null) {
            this.setNull(parameterIndex, 4);
        } else if (obj instanceof String) {
            this.setString(parameterIndex, (String)obj);
        } else if (obj instanceof Integer) {
            this.setInt(parameterIndex, (Integer)obj);
        } else if (obj instanceof Long) {
            this.setLong(parameterIndex, (Long)obj);
        } else if (obj instanceof Short) {
            this.setShort(parameterIndex, (Short)obj);
        } else if (obj instanceof Double) {
            this.setDouble(parameterIndex, (Double)obj);
        } else if (obj instanceof Float) {
            this.setFloat(parameterIndex, ((Float)obj).floatValue());
        } else if (obj instanceof Byte) {
            this.setByte(parameterIndex, (Byte)obj);
        } else if (obj instanceof byte[]) {
            this.setBytes(parameterIndex, (byte[])obj);
        } else if (obj instanceof Date) {
            this.setDate(parameterIndex, (Date)obj);
        } else if (obj instanceof Time) {
            this.setTime(parameterIndex, (Time)obj);
        } else if (obj instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)obj);
        } else if (obj instanceof java.util.Date) {
            this.setTimestamp(parameterIndex, new Timestamp(((java.util.Date)obj).getTime()));
        } else if (obj instanceof Boolean) {
            this.setBoolean(parameterIndex, (Boolean)obj);
        } else if (obj instanceof Blob) {
            this.setBlob(parameterIndex, (Blob)obj);
        } else if (obj instanceof InputStream) {
            this.setBinaryStream(parameterIndex, (InputStream)obj);
        } else if (obj instanceof Reader) {
            this.setCharacterStream(parameterIndex, (Reader)obj);
        } else if (obj instanceof BigDecimal) {
            this.setBigDecimal(parameterIndex, (BigDecimal)obj);
        } else if (obj instanceof BigInteger) {
            this.setString(parameterIndex, obj.toString());
        } else if (obj instanceof Clob) {
            this.setClob(parameterIndex, (Clob)obj);
        } else if (LocalDateTime.class.isInstance(obj)) {
            this.setTimestamp(parameterIndex, Timestamp.valueOf((LocalDateTime)LocalDateTime.class.cast(obj)));
        } else if (Instant.class.isInstance(obj)) {
            this.setTimestamp(parameterIndex, Timestamp.from((Instant)Instant.class.cast(obj)));
        } else if (LocalDate.class.isInstance(obj)) {
            this.setDate(parameterIndex, Date.valueOf((LocalDate)LocalDate.class.cast(obj)));
        } else if (OffsetDateTime.class.isInstance(obj)) {
            this.setParameter(parameterIndex, new ZonedDateTimeParameter(((OffsetDateTime)OffsetDateTime.class.cast(obj)).toZonedDateTime(), this.protocol.getTimeZone().toZoneId(), this.useFractionalSeconds, this.options));
        } else if (OffsetTime.class.isInstance(obj)) {
            this.setParameter(parameterIndex, new OffsetTimeParameter((OffsetTime)OffsetTime.class.cast(obj), this.protocol.getTimeZone().toZoneId(), this.useFractionalSeconds, this.options));
        } else if (ZonedDateTime.class.isInstance(obj)) {
            this.setParameter(parameterIndex, new ZonedDateTimeParameter((ZonedDateTime)ZonedDateTime.class.cast(obj), this.protocol.getTimeZone().toZoneId(), this.useFractionalSeconds, this.options));
        } else if (LocalTime.class.isInstance(obj)) {
            this.setTime(parameterIndex, Time.valueOf((LocalTime)LocalTime.class.cast(obj)));
        } else {
            try {
                this.setParameter(parameterIndex, new SerializableParameter(obj, this.connection.noBackslashEscapes));
                this.hasLongData = true;
            }
            catch (IOException e) {
                throw ExceptionMapper.getSqlException("Could not set parameter in setObject, Object class is not handled (Class : " + obj.getClass() + ")");
            }
        }
    }

    @Override
    public void setObject(int parameterIndex, Object obj, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.setObject(parameterIndex, obj, targetSqlType.getVendorTypeNumber(), scaleOrLength);
    }

    @Override
    public void setObject(int parameterIndex, Object obj, SQLType targetSqlType) throws SQLException {
        this.setObject(parameterIndex, obj, targetSqlType.getVendorTypeNumber());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setInternalObject(int parameterIndex, Object obj, int targetSqlType, long scaleOrLength) throws SQLException {
        switch (targetSqlType) {
            case -8: 
            case 70: 
            case 2000: 
            case 2002: 
            case 2003: 
            case 2006: 
            case 2009: {
                throw ExceptionMapper.getFeatureNotSupportedException("Type not supported");
            }
        }
        if (obj == null) {
            this.setNull(parameterIndex, 4);
            return;
        } else if (obj instanceof String) {
            if (targetSqlType == 2004) {
                throw ExceptionMapper.getSqlException("Cannot convert a String to a Blob");
            }
            String str = (String)obj;
            try {
                switch (targetSqlType) {
                    case -7: 
                    case 16: {
                        this.setBoolean(parameterIndex, !"false".equalsIgnoreCase(str) && !"0".equals(str));
                        return;
                    }
                    case -6: {
                        this.setByte(parameterIndex, Byte.parseByte(str));
                        return;
                    }
                    case 5: {
                        this.setShort(parameterIndex, Short.parseShort(str));
                        return;
                    }
                    case 4: {
                        this.setInt(parameterIndex, Integer.parseInt(str));
                        return;
                    }
                    case 6: 
                    case 8: {
                        this.setDouble(parameterIndex, Double.valueOf(str));
                        return;
                    }
                    case 7: {
                        this.setFloat(parameterIndex, Float.valueOf(str).floatValue());
                        return;
                    }
                    case -5: {
                        this.setLong(parameterIndex, Long.valueOf(str));
                        return;
                    }
                    case 2: 
                    case 3: {
                        this.setBigDecimal(parameterIndex, new BigDecimal(str));
                        return;
                    }
                    case -16: 
                    case -15: 
                    case -9: 
                    case -1: 
                    case 1: 
                    case 12: 
                    case 2005: 
                    case 2011: {
                        this.setString(parameterIndex, str);
                        return;
                    }
                    case 93: {
                        if (str.startsWith("0000-00-00")) {
                            this.setTimestamp(parameterIndex, null);
                            return;
                        }
                        this.setTimestamp(parameterIndex, Timestamp.valueOf(str));
                        return;
                    }
                    case 92: {
                        this.setTime(parameterIndex, Time.valueOf((String)obj));
                        return;
                    }
                    case 2013: {
                        this.setParameter(parameterIndex, new OffsetTimeParameter(OffsetTime.parse(str), this.protocol.getTimeZone().toZoneId(), this.useFractionalSeconds, this.options));
                        return;
                    }
                    case 2014: {
                        this.setParameter(parameterIndex, new ZonedDateTimeParameter(ZonedDateTime.parse(str, SPEC_ISO_ZONED_DATE_TIME), this.protocol.getTimeZone().toZoneId(), this.useFractionalSeconds, this.options));
                        return;
                    }
                    default: {
                        throw ExceptionMapper.getSqlException("Could not convert [" + str + "] to " + targetSqlType);
                    }
                }
            }
            catch (IllegalArgumentException e) {
                throw ExceptionMapper.getSqlException("Could not convert [" + str + "] to " + targetSqlType, e);
            }
        } else if (obj instanceof Number) {
            this.testNumbers(targetSqlType);
            Number bd = (Number)obj;
            switch (targetSqlType) {
                case -6: {
                    this.setByte(parameterIndex, bd.byteValue());
                    return;
                }
                case 5: {
                    this.setShort(parameterIndex, bd.shortValue());
                    return;
                }
                case 4: {
                    this.setInt(parameterIndex, bd.intValue());
                    return;
                }
                case -5: {
                    this.setLong(parameterIndex, bd.longValue());
                    return;
                }
                case 6: 
                case 8: {
                    this.setDouble(parameterIndex, bd.doubleValue());
                    return;
                }
                case 7: {
                    this.setFloat(parameterIndex, bd.floatValue());
                    return;
                }
                case 2: 
                case 3: {
                    if (obj instanceof BigDecimal) {
                        this.setBigDecimal(parameterIndex, (BigDecimal)obj);
                        return;
                    }
                    if (obj instanceof Double || obj instanceof Float) {
                        this.setDouble(parameterIndex, bd.doubleValue());
                        return;
                    }
                    this.setLong(parameterIndex, bd.longValue());
                    return;
                }
                case -7: {
                    this.setBoolean(parameterIndex, bd.shortValue() != 0);
                    return;
                }
                case 1: 
                case 12: {
                    this.setString(parameterIndex, bd.toString());
                    return;
                }
                default: {
                    throw ExceptionMapper.getSqlException("Could not convert [" + bd + "] to " + targetSqlType);
                }
            }
        } else if (obj instanceof byte[]) {
            if (targetSqlType != -2 && targetSqlType != -3 && targetSqlType != -4) throw ExceptionMapper.getSqlException("Can only convert a byte[] to BINARY, VARBINARY or LONGVARBINARY");
            this.setBytes(parameterIndex, (byte[])obj);
            return;
        } else if (obj instanceof Time) {
            this.setTime(parameterIndex, (Time)obj);
            return;
        } else if (obj instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)obj);
            return;
        } else if (obj instanceof Date) {
            this.setDate(parameterIndex, (Date)obj);
            return;
        } else if (obj instanceof java.util.Date) {
            long timemillis = ((java.util.Date)obj).getTime();
            if (targetSqlType == 91) {
                this.setDate(parameterIndex, new Date(timemillis));
                return;
            } else if (targetSqlType == 92) {
                this.setTime(parameterIndex, new Time(timemillis));
                return;
            } else {
                if (targetSqlType != 93) return;
                this.setTimestamp(parameterIndex, new Timestamp(timemillis));
            }
            return;
        } else if (obj instanceof Boolean) {
            this.testNumbers(targetSqlType);
            this.setBoolean(parameterIndex, (Boolean)obj);
            return;
        } else if (obj instanceof Blob) {
            this.setBlob(parameterIndex, (Blob)obj);
            return;
        } else if (obj instanceof BigInteger) {
            this.setString(parameterIndex, obj.toString());
            return;
        } else if (obj instanceof Clob) {
            this.setClob(parameterIndex, (Clob)obj);
            return;
        } else if (obj instanceof InputStream) {
            this.setBinaryStream(parameterIndex, (InputStream)obj, scaleOrLength);
            return;
        } else if (obj instanceof Reader) {
            this.setCharacterStream(parameterIndex, (Reader)obj, scaleOrLength);
            return;
        } else if (LocalDateTime.class.isInstance(obj)) {
            this.setTimestamp(parameterIndex, Timestamp.valueOf((LocalDateTime)LocalDateTime.class.cast(obj)));
            return;
        } else if (Instant.class.isInstance(obj)) {
            this.setTimestamp(parameterIndex, Timestamp.from((Instant)Instant.class.cast(obj)));
            return;
        } else if (LocalDate.class.isInstance(obj)) {
            this.setDate(parameterIndex, Date.valueOf((LocalDate)LocalDate.class.cast(obj)));
            return;
        } else if (OffsetDateTime.class.isInstance(obj)) {
            this.setParameter(parameterIndex, new ZonedDateTimeParameter(((OffsetDateTime)OffsetDateTime.class.cast(obj)).toZonedDateTime(), this.protocol.getTimeZone().toZoneId(), this.useFractionalSeconds, this.options));
            return;
        } else if (OffsetTime.class.isInstance(obj)) {
            this.setParameter(parameterIndex, new OffsetTimeParameter((OffsetTime)OffsetTime.class.cast(obj), this.protocol.getTimeZone().toZoneId(), this.useFractionalSeconds, this.options));
            return;
        } else if (ZonedDateTime.class.isInstance(obj)) {
            this.setParameter(parameterIndex, new ZonedDateTimeParameter((ZonedDateTime)ZonedDateTime.class.cast(obj), this.protocol.getTimeZone().toZoneId(), this.useFractionalSeconds, this.options));
            return;
        } else {
            if (!LocalTime.class.isInstance(obj)) throw ExceptionMapper.getSqlException("Could not set parameter in setObject, could not convert: " + obj.getClass() + " to " + targetSqlType);
            this.setTime(parameterIndex, Time.valueOf((LocalTime)LocalTime.class.cast(obj)));
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream stream, long length) throws SQLException {
        if (stream == null) {
            this.setNull(parameterIndex, ColumnType.BLOB);
            return;
        }
        this.setParameter(parameterIndex, new StreamParameter(stream, length, this.connection.noBackslashEscapes));
        this.hasLongData = true;
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream stream) throws SQLException {
        if (stream == null) {
            this.setNull(parameterIndex, ColumnType.BLOB);
            return;
        }
        this.setParameter(parameterIndex, new StreamParameter(stream, this.connection.noBackslashEscapes));
        this.hasLongData = true;
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream stream, int length) throws SQLException {
        if (stream == null) {
            this.setNull(parameterIndex, ColumnType.BLOB);
            return;
        }
        this.setParameter(parameterIndex, new StreamParameter(stream, length, this.connection.noBackslashEscapes));
        this.hasLongData = true;
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream stream, long length) throws SQLException {
        if (stream == null) {
            this.setNull(parameterIndex, ColumnType.BLOB);
            return;
        }
        this.setParameter(parameterIndex, new StreamParameter(stream, length, this.connection.noBackslashEscapes));
        this.hasLongData = true;
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream stream) throws SQLException {
        if (stream == null) {
            this.setNull(parameterIndex, ColumnType.BLOB);
            return;
        }
        this.setParameter(parameterIndex, new StreamParameter(stream, this.connection.noBackslashEscapes));
        this.hasLongData = true;
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream stream, int length) throws SQLException {
        if (stream == null) {
            this.setNull(parameterIndex, ColumnType.BLOB);
            return;
        }
        this.setParameter(parameterIndex, new StreamParameter(stream, length, this.connection.noBackslashEscapes));
        this.hasLongData = true;
    }

    @Override
    public void setBoolean(int parameterIndex, boolean value) throws SQLException {
        this.setParameter(parameterIndex, new ByteParameter(value ? (byte)1 : 0));
    }

    @Override
    public void setByte(int parameterIndex, byte bit) throws SQLException {
        this.setParameter(parameterIndex, new ByteParameter(bit));
    }

    @Override
    public void setShort(int parameterIndex, short value) throws SQLException {
        this.setParameter(parameterIndex, new ShortParameter(value));
    }

    @Override
    public void setString(int parameterIndex, String str) throws SQLException {
        if (str == null) {
            this.setNull(parameterIndex, ColumnType.VARCHAR);
            return;
        }
        this.setParameter(parameterIndex, new StringParameter(str, this.connection.noBackslashEscapes));
    }

    @Override
    public void setBytes(int parameterIndex, byte[] bytes) throws SQLException {
        if (bytes == null) {
            this.setNull(parameterIndex, ColumnType.BLOB);
            return;
        }
        this.setParameter(parameterIndex, new ByteArrayParameter(bytes, this.connection.noBackslashEscapes));
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 2004);
            return;
        }
        this.setParameter(parameterIndex, new StreamParameter(x, length, this.connection.noBackslashEscapes));
        this.hasLongData = true;
    }

    private void testNumbers(int targetSqlType) throws SQLException {
        switch (targetSqlType) {
            case -4: 
            case -3: 
            case -2: 
            case 91: 
            case 92: 
            case 93: 
            case 2004: {
                throw ExceptionMapper.getSqlException("Cannot convert to " + targetSqlType);
            }
        }
    }

    @Override
    public void setInt(int column, int value) throws SQLException {
        this.setParameter(column, new IntParameter(value));
    }

    @Override
    public void setLong(int parameterIndex, long value) throws SQLException {
        this.setParameter(parameterIndex, new LongParameter(value));
    }

    @Override
    public void setFloat(int parameterIndex, float value) throws SQLException {
        this.setParameter(parameterIndex, new FloatParameter(value));
    }

    @Override
    public void setDouble(int parameterIndex, double value) throws SQLException {
        this.setParameter(parameterIndex, new DoubleParameter(value));
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal bigDecimal) throws SQLException {
        if (bigDecimal == null) {
            this.setNull(parameterIndex, ColumnType.DECIMAL);
            return;
        }
        this.setParameter(parameterIndex, new BigDecimalParameter(bigDecimal));
    }
}

